<?php

namespace QuadLayers\IGG_PRO\Backend;

use QuadLayers\IGG\Backend\Load as Backend;
use QuadLayers\IGG\Models\Account as Models_Account;

class Load {

	protected static $instance;

	public function __construct() {
		add_action( 'admin_enqueue_scripts', array( $this, 'register_scripts' ), 10 );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ), 10 );
		add_action( 'admin_menu', array( $this, 'add_menu' ) );
		add_action( 'init', array( self::class, 'init_add_account' ) );
		remove_action( 'init', array( 'QuadLayers\IGG\Backend\Load', 'init_add_account' ) );
		remove_action( 'admin_head', array( 'QuadLayers\IGG\Backend\Load', 'add_premium_js' ) );
		remove_action( 'admin_footer', array( 'QuadLayers\IGG\Backend\Load', 'add_premium_css' ) );
	}

	public function add_menu() {

		$menu_slug = Backend::get_menu_slug();

		add_submenu_page(
			$menu_slug,
			esc_html__( 'License', 'insta-gallery-pro' ),
			esc_html__( 'License', 'insta-gallery-pro' ),
			'qligg_manage_feeds',
			'qligg_backend&tab=license',
			'__return_null'
		);

		remove_submenu_page( $menu_slug, "{$menu_slug}&tab=premium" );

	}

	public function register_scripts() {

		global $qligg_license_client;

		$routes_paths = array();

		$backend = include_once QLIGG_PRO_PLUGIN_DIR . 'build/backend/js/index.asset.php';

		if ( ! empty( $qligg_license_client->routes->get() ) ) {
			$routes_paths = array_map(
				function( $route ) {
					return $route->get_rest_path();
				},
				$qligg_license_client->routes->get()
			);
		}

		wp_register_style(
			'qligg-pro-backend',
			plugins_url( '/build/backend/css/style.css', QLIGG_PRO_PLUGIN_FILE ),
			array(
				'media-views',
				'wp-components',
				'wp-editor',
			),
			QLIGG_PRO_PLUGIN_VERSION
		);

		wp_register_script(
			'qligg-pro-backend',
			plugins_url( '/build/backend/js/index.js', QLIGG_PRO_PLUGIN_FILE ),
			$backend['dependencies'],
			$backend['version'],
			true
		);

		wp_localize_script(
			'qligg-pro-backend',
			'qligg_pro_backend',
			array(
				'licenseClientRoutesPaths' => $routes_paths,
				'plugin_url'               => plugins_url( '/', QLIGG_PRO_PLUGIN_FILE ),
				'QLIGG_PRO_DEMO_URL'       => QLIGG_PRO_DEMO_URL,
				'QLIGG_PRO_LICENSES_URL'   => QLIGG_PRO_LICENSES_URL,
				'QLIGG_PRO_SUPPORT_URL'    => QLIGG_PRO_SUPPORT_URL,
			)
		);

	}

	public function enqueue_scripts() {
		$menu_slug = Backend::get_menu_slug();
		if ( ! isset( $_GET['page'] ) || $_GET['page'] !== $menu_slug ) {
			return;
		}
		wp_enqueue_style( 'qligg-pro-backend' );
		wp_enqueue_script( 'qligg-pro-backend' );
	}

	public static function init_add_account() {

		if ( ! is_admin() ) {
			return;
		}

		if ( ! isset( $_REQUEST['accounts'][0]['id'] ) ) {
			return;
		}

		$models_account = new Models_Account();

		foreach ( $_REQUEST['accounts'] as $account_data ) {

			if (
			isset( $account_data['id'] ) &&
			isset( $account_data['access_token'] ) &&
			isset( $account_data['access_token_type'] ) &&
			isset( $account_data['expires_in'] )
			) {
				$models_account->create( $account_data );
			}
		}

		/*
		 * Redirect via php is not working because it preserve the hash in the url
		if ( wp_safe_redirect( admin_url() ) ) {
			exit;
		}
		*/

		/**
		 * Don't escape because it replace & with &#038;
		 */
		?>
		<script type="text/javascript">
			window.location.replace("<?php echo QLIGG_ACCOUNT_URL; ?>");
		</script>
		<?php

	}

	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}
